<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BookingConsumption extends Model 
{

    protected $table = 'booking_consumptions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function consumption()
    {
        return $this->hasOne('App\Models\Consumption');
    }

    public function location()
    {
        return $this->hasOne('App\Models\Location');
    }

}